#import "@preview/codly:1.3.0": *
#import "@preview/codly-languages:0.1.8": codly-languages
#import "@preview/i-figured:0.2.4": show-equation
#import "@preview/physica:0.9.5": *
#import "@preview/tablem:0.2.0": tablem, three-line-table
#import "@preview/thmbox:0.2.0": *
#import "@preview/unify:0.7.1": unit
#import "@preview/zero:0.3.3": num, set-num

#let SongTi = ("New Computer Modern", "SimSun")
#let HeiTi = ("New Computer Modern", "SimHei")
#let KaiTi = ("New Computer Modern", "KaiTi")

#let project(
  title,
  author,
  id,
  department: none,
  date: datetime.today(),
  teacher: none,
  school: none,
  abstract: none,
  keywords: none,
  show-outline: false,
  watermark: none,
  column: 1,
  body
) = {
  // Style
  set page(
    paper: "a4",
    header: context if here().page() != 1 {
      align(center)[#title]
      v(-0.5em)
      line(length: 100%, stroke: 0.75pt)
    },
    numbering: "1",
    background: watermark
  )
  set text(
    lang: "zh",
    region: "cn",
    font: SongTi
  )
  show text.where(weight: "bold"): set text(
    font: HeiTi
  )
  show strong: set text(
    font: HeiTi
  )
  show emph: set text(
    font: KaiTi
  )
  set heading(numbering: "1.1")
  show heading: it => {
    it
    v(0.5em)
  }
  set par(
    justify: true,
    leading: 0.9em,
    first-line-indent: (
      amount: 2em,
      all: true
    )
  )
  show list: set par(first-line-indent: 0em)
  show figure.where(kind: table): set figure.caption(
    position: top
  )
  show figure: set image(width: 60%)
  show math.equation: show-equation
  show math.equation.where(block: false): it => {
    math.display(it)
  }
  set-num(uncertainty-mode: "compact")
  show: codly-init
  codly(
    fill: luma(240),
    languages: codly-languages,
    zebra-fill: none
  )
  show: thmbox-init()
  set bibliography(full: true)
  show cite: it => math.attach("",tr: it)

  let btext(body, size: 13pt) = {
    block(text(size: size)[#body])
  }

  // Title
  v(4em)
  align(center)[
    #btext(size: 18pt)[#title]
    #v(1em)
    #btext()[姓名：#author]
    #btext()[学号：#id]
    #if department != none {
      btext()[学院：#department]
    }
    #v(0.5em)
    #btext()[#date.year()年#date.month()月#date.day()日]
    #if teacher != none or school != none {
      v(1.5em)
    }
    #if teacher != none {
      btext(size: 12pt)[*指导老师：#teacher*]
    }
    #if school != none {
      btext(size: 12pt)[*学校：#school*]
    }
  ]
  v(2em)

  // Abstract & Keywords
  if abstract != none {
    heading(
      depth: 2,
      numbering: none,
      outlined: false
    )[摘要]
    abstract
  }
  if keywords != none {
    par(first-line-indent: 0em)[
      *关键词：*#keywords.join("；")
    ]
  }
  v(2em)

  // Outline
  if show-outline {
    outline()
    pagebreak()
  }

  // Content
  columns(column, body)
}

#let appendix(body) = {
  heading(numbering: none)[附录]
  set figure(numbering: none)
  body
}
#let tablem = tablem.with(align: center+horizon)

// Units & Quantities
#let unit = it => {
  it.split("-").map(
    u => unit(u, per: "fraction-short")
  ).join(math.dot)
}
#let qty(val, u) = {
  num(val) + unit(u)
}

#let show-code-file(
  path,
  lang: none
) = {
  raw(read(path), lang: lang, block: true)
}

#let nm = unit("nm")
#let um = unit("um")
#let mm = unit("mm")
#let cm = unit("cm")
#let m = unit("m")
#let cm3 = unit("cm^3")
#let m3 = unit("m^3")
#let us = unit("us")
#let ms = unit("ms")
#let s = unit("s")
#let Hz = unit("Hz")
#let kHz = unit("kHz")
#let m-s = unit("m/s")
#let m-s2 = unit("m/s^2")
#let g = unit("g")
#let kg = unit("kg")
#let N = unit("N")
#let J = unit("J")
#let Pa = unit("Pa")
#let mV = unit("mV")
#let V = unit("V")
#let mA = unit("mA")
#let A = unit("A")
#let Cel = unit("Celsius")
#let K = unit("K")
